"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppletVersionFixturesFactories = exports.createAppletVersion = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createAppletVersion({ applet, customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.uuid(), appletUid: applet.uid, version: faker_1.faker.system.semver(), createdAt: faker_1.faker.datatype.datetime(), updatedAt: faker_1.faker.datatype.datetime(), publishedSince: faker_1.faker.datatype.datetime() }, customFields);
}
exports.createAppletVersion = createAppletVersion;
function createAppletVersionFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.AppletVersion,
        createEntity: createAppletVersion,
    });
}
exports.createAppletVersionFixturesFactories = createAppletVersionFixturesFactories;
//# sourceMappingURL=appletVersionFixtures.js.map