"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppletFixturesFactories = exports.createApplet = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createApplet({ organization, customFields }) {
    return Object.assign({ uid: faker_1.faker.datatype.uuid(), name: faker_1.faker.hacker.adjective(), organizationUid: organization.uid, createdAt: faker_1.faker.datatype.datetime() }, customFields);
}
exports.createApplet = createApplet;
function createAppletFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Applet,
        createEntity: createApplet,
    });
}
exports.createAppletFixturesFactories = createAppletFixturesFactories;
//# sourceMappingURL=appletFixtures.js.map