"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAlertRuleFixturesFactories = exports.createAlertRule = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createAlertRule({ company, customFields }) {
    var _a, _b, _c, _d;
    return Object.assign({ alertRuleUid: faker_1.default.datatype.uuid(), name: faker_1.default.hacker.noun(), companyUid: company.uid, createdAt: (_a = customFields === null || customFields === void 0 ? void 0 : customFields.createdAt) !== null && _a !== void 0 ? _a : new Date(), history: (_b = customFields === null || customFields === void 0 ? void 0 : customFields.history) !== null && _b !== void 0 ? _b : [], archivedAt: (_c = customFields === null || customFields === void 0 ? void 0 : customFields.archivedAt) !== null && _c !== void 0 ? _c : null, pausedAt: (_d = customFields === null || customFields === void 0 ? void 0 : customFields.archivedAt) !== null && _d !== void 0 ? _d : null }, customFields);
}
exports.createAlertRule = createAlertRule;
function createAlertRuleFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.AlertRule,
        createEntity: createAlertRule,
    });
}
exports.createAlertRuleFixturesFactories = createAlertRuleFixturesFactories;
//# sourceMappingURL=alertRuleFixtures.js.map