import { IAlertRule } from '../../Schema/Alert/alertRuleModel';
import { Company } from '../Organization/organizationFixtures';
export declare type CustomFields = Partial<Omit<IAlertRule, 'companyUid'>>;
export interface CreateProps {
    company: Company;
    customFields?: CustomFields;
}
export declare function createAlertRule({ company, customFields }: CreateProps): IAlertRule;
export declare function createAlertRuleFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IAlertRule, Partial<Omit<IAlertRule, "companyUid">>, CreateProps & {
        customFields?: Partial<Omit<IAlertRule, "companyUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IAlertRule, Partial<Omit<IAlertRule, "companyUid">>, CreateProps & {
        customFields?: Partial<Omit<IAlertRule, "companyUid">> | undefined;
    }>;
};
//# sourceMappingURL=alertRuleFixtures.d.ts.map