import { IAlert } from '../../Schema/Alert/alertModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
import { IAlertRule } from '../../Schema/Alert/alertRuleModel';
import { IDevice } from '../../Schema/Device/deviceModel';
export declare type CustomFields = Partial<Omit<IAlert, 'organizationUid' | 'alertRuleUid' | 'deviceIdentityHashes'>>;
export interface CreateProps {
    organization: IOrganization;
    alertRule: IAlertRule;
    devices?: IDevice[];
    customFields?: CustomFields;
}
export declare function createAlert({ organization, alertRule, devices, customFields }: CreateProps): IAlert;
export declare function createAlertFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IAlert, Partial<Omit<IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">>, CreateProps & {
        customFields?: Partial<Omit<IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IAlert, Partial<Omit<IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">>, CreateProps & {
        customFields?: Partial<Omit<IAlert, "organizationUid" | "alertRuleUid" | "deviceIdentityHashes">> | undefined;
    }>;
};
//# sourceMappingURL=alertFixtures.d.ts.map