"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAccountSettingsFixturesFactories = exports.createAccountSettings = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
function createAccountSettings({ account, customFields }) {
    return Object.assign({ accountId: account.id, email: {
            isSubscribedToNewsletter: faker_1.faker.random.boolean(),
            notificationAlertLevels: faker_1.faker.random.arrayElements(['info', 'warning', 'error']),
        }, apiSecurityTokens: [] }, customFields);
}
exports.createAccountSettings = createAccountSettings;
function createAccountSettingsFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.AccountSettings,
        createEntity: createAccountSettings,
    });
}
exports.createAccountSettingsFixturesFactories = createAccountSettingsFixturesFactories;
//# sourceMappingURL=accountSettingsFixtures.js.map