import { IAccount } from '../../../Schema/Account/accountModel';
import { IAccountSettings } from '../../../Schema/Account/accountSettingsModel';
export declare type CustomFields = Partial<IAccountSettings>;
export interface CreateProps {
    account: IAccount;
    customFields?: CustomFields;
}
export declare function createAccountSettings({ account, customFields }: CreateProps): IAccountSettings;
export declare function createAccountSettingsFixturesFactories(): {
    createSimpleFactory(): import("../../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IAccountSettings, Partial<IAccountSettings>, CreateProps & {
        customFields?: Partial<IAccountSettings> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IAccountSettings, Partial<IAccountSettings>, CreateProps & {
        customFields?: Partial<IAccountSettings> | undefined;
    }>;
};
//# sourceMappingURL=accountSettingsFixtures.d.ts.map