"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceModel = void 0;
const key_1 = require("../key");
const RedisCache_1 = require("../RedisCache");
const deviceModel_1 = require("../../Base/Device/deviceModel");
const PREFIX = (0, key_1.getFullKey)('device');
const createDeviceModel = (conn, baseModel) => {
    const cache = new RedisCache_1.RedisCache(conn, PREFIX);
    return (0, deviceModel_1.createDeviceModel)(baseModel, cache);
};
exports.createDeviceModel = createDeviceModel;
//# sourceMappingURL=deviceModel.js.map