"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceMonitoringLogBatchedModel = void 0;
const BatchCreator_1 = require("./BatchCreator");
const createDeviceMonitoringLogBatchedModel = (baseModel, batchSize) => {
    const batchCreator = new BatchCreator_1.BatchCreator(batchSize !== null && batchSize !== void 0 ? batchSize : 10, (...args) => baseModel.createMany(...args));
    return Object.assign(Object.assign({}, baseModel), { create(id, type, device, createdAt, data) {
            return __awaiter(this, void 0, void 0, function* () {
                const monitoringLog = {
                    id,
                    deviceIdentityHash: device.identityHash,
                    organizationUid: device.organizationUid === null ? undefined : device.organizationUid,
                    type,
                    createdAt,
                    data,
                };
                yield batchCreator.create(monitoringLog);
            });
        } });
};
exports.createDeviceMonitoringLogBatchedModel = createDeviceMonitoringLogBatchedModel;
//# sourceMappingURL=deviceMonitoringLogBatchedModel.js.map