"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchCreator = void 0;
const events_1 = require("events");
const Debug = require("debug");
const AsyncLock = require("async-lock");
const debug = Debug('@signageos/user-domain-model:Influx:helper');
class BatchCreator {
    constructor(bufferLength, actionCreateMany) {
        this.bufferLength = bufferLength;
        this.actionCreateMany = actionCreateMany;
        this.buffer = [];
        this.eventEmitter = new events_1.EventEmitter();
        this.lock = new AsyncLock();
        debug('Batch creator initialized with buffer size %d', this.bufferLength);
    }
    create(item) {
        return __awaiter(this, void 0, void 0, function* () {
            const prom = this.waitForBufferFlushed();
            yield this.insert(item);
            yield prom;
        });
    }
    insert(item) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.lock.acquire('locked', () => __awaiter(this, void 0, void 0, function* () {
                this.buffer.push(item);
                debug('Pushed to %d buffer %o and buffer %o', this.buffer.length, item, this.buffer);
                if (this.buffer.length >= this.bufferLength) {
                    yield this.actionCreateMany(this.buffer);
                    debug('Flush buffer %o', this.buffer);
                    this.buffer = [];
                    this.eventEmitter.emit('buffer_flushed');
                }
            }));
        });
    }
    waitForBufferFlushed() {
        return new Promise((resolve) => {
            this.eventEmitter.once('buffer_flushed', () => {
                resolve();
            });
        });
    }
}
exports.BatchCreator = BatchCreator;
//# sourceMappingURL=BatchCreator.js.map