# User Domain Model

The domain model from user point of view.
This repository is generaly concentrated to a schema of a data model 
accessible from the user perspective.
Data will be stored in mongodb.

### Execute integration tests on local Winsows 10 machine

prerequisites:
- Redis server
- Mongodb

#### Redis server installation (WSL):
1. run this command under admin priviliges in powershell
```sh
$ Enable-WindowsOptionalFeature -Online -FeatureName Microsoft-Windows-Subsystem-Linux
```
2. reboot system
3. download and install linux distro  [i.e. Ubuntu 18.04](https://www.microsoft.com/en-us/p/ubuntu-1804/9n9tngvndl3q)
4. run the following commands in the newly installed terminal:
```sh
$ sudo apt-get update
$ sudo apt-get upgrade
$ sudo apt-get install redis-server
$ sudo service redis-server restart
```

#### Mongodb
- Create database
- In the installation folder bin directory contains [_mongod.cfg_](https://docs.mongodb.com/manual/reference/configuration-options/#replication-options) file next lines:

`replication:`
&nbsp;&nbsp;&nbsp;&nbsp;`replSetName: main`

note: use SPACES only

run the next command in the mongo interactive mode

```sh
rs.initiate({ _id: "main", version: 1, members: [{ _id: 0, host : "127.0.0.1:27017" }] });
```

## Tests

In the project add to the config folder `env.test.json` add the following properties:
`"redis_dsn": "redis://localhost:6379"`
`"mongo_db_dsn": "mongodb://localhost:27017/${dbName}"`

Rename the file `default.spec.ts` to `_default.spec.ts`

change in `package.json`:
`"test": "env NODE_ENV=test mocha --opts mocha.opts"`

Run in the project directory:
```sh 
$ npm test

or you can pass the env variables directly

$ mongo_db_dsn=mongodb://localhost:27017/test redis_dsn=redis://localhost:6379 npm test
```

### Docker-compose

There is also prepared `docker-compose.yml` ready for your development. It starts the required mongodb and redis services.
Be sure you copy `.env.docker-compose.dist` to `.env.docker-compose` and fill your own valid token. Then you may run the tests by:
```
docker-compose up -d
# make sure there are correct dependencies
docker-compose exec app rm -rf node_modules
# you must login to sOS npm before installing private packages
docker-compose exec app npm login --registry=https://npm.signageos.io/
docker-compose exec app npm install

docker-compose exec app npm run lint
docker-compose exec app npm run test
```  

## Implementation guide lines

  * [How to handle pagination and sorting](/docs/pagination-sorting.md)
  * [How to use and write fixtures for tests](/docs/fixtures.md)
  * [How to write models](/docs/writting-models.md)
  * [How to write command models](/docs/command-models.md)
