"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUnionTypeRecursive = void 0;
const checksum_1 = require("../Hash/checksum");
const moduleDiscoverer_1 = require("../FileSystem/moduleDiscoverer");
function generateUnionTypeRecursive(path, typeName = 'IUnionType') {
    const moduleExports = (0, moduleDiscoverer_1.getModuleExportsRecursive)(path);
    const stringModuleExports = moduleExports.filter((moduleExport) => typeof moduleExport.value === 'string');
    const imports = stringModuleExports.reduce((reduction, moduleExport) => {
        const hash = checksumModuleExport(moduleExport);
        return reduction + `\nimport { ${moduleExport.export} as ${hash} } from '${moduleExport.relativePath}';`;
    }, '');
    const unionTypes = stringModuleExports.map((moduleExport) => checksumModuleExport(moduleExport)).join(' | ');
    return `${imports}
type ${typeName} = ${unionTypes.length ? unionTypes : 'void'};
export default ${typeName};
`;
}
exports.generateUnionTypeRecursive = generateUnionTypeRecursive;
function checksumModuleExport(moduleExport) {
    return moduleExport.export + '_' + (0, checksum_1.checksumString)(moduleExport.relativePath, 5);
}
//# sourceMappingURL=generator.js.map