"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function wait(timeout) {
    let timer = undefined;
    let rejectCallback = null;
    const promise = new Promise((resolve, reject) => {
        rejectCallback = reject;
        timer = setTimeout(() => {
            rejectCallback = null;
            resolve();
        }, timeout);
    });
    promise.cancel = () => {
        if (timer) {
            clearTimeout(timer);
            timer = undefined;
            if (rejectCallback) {
                rejectCallback(new Error('Wait cancelled'));
            }
            rejectCallback = null;
        }
    };
    return promise;
}
exports.default = wait;
//# sourceMappingURL=wait.js.map