"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withTimeout = exports.rejectAfterTimeout = exports.TimeoutError = void 0;
class TimeoutError extends Error {
    constructor(message) {
        super(message !== null && message !== void 0 ? message : 'Timeout');
        // Set the prototype explicitly because of bug in TypeScript https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(this, TimeoutError.prototype);
    }
}
exports.TimeoutError = TimeoutError;
function rejectAfterTimeout(timeout, errorMessage) {
    return new Promise((_resolve, reject) => {
        setTimeout(() => reject(new TimeoutError(errorMessage)), timeout);
    });
}
exports.rejectAfterTimeout = rejectAfterTimeout;
/**
 * Wraps promise and returns a new promise that will be rejected
 * after timeoutMs if the original promise is not resolved or rejected.
 */
function withTimeout(promise, timeoutMs) {
    return Promise.race([promise, rejectAfterTimeout(timeoutMs)]);
}
exports.withTimeout = withTimeout;
//# sourceMappingURL=timeout.js.map