"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.suppressUncaughtExceptions = exports.handleSignals = exports.stopService = void 0;
const generator_1 = require("../Hash/generator");
process.uid = (0, generator_1.generateUniqueHash)();
const stopService = (service) => __awaiter(void 0, void 0, void 0, function* () {
    process.removeAllListeners('SIGTERM');
    process.removeAllListeners('SIGINT');
    console.info('Service is stopping');
    yield service.stop();
    console.info('Service stopped');
    process.exit(0);
});
exports.stopService = stopService;
function handleSignals(service) {
    const onExit = () => (0, exports.stopService)(service);
    process.on('SIGINT', onExit);
    process.on('SIGTERM', onExit);
}
exports.handleSignals = handleSignals;
function suppressUncaughtExceptions() {
    process.removeAllListeners('uncaughtException');
    process.on('uncaughtException', (error) => {
        console.error(error && error.stack ? error.stack : error);
    });
}
exports.suppressUncaughtExceptions = suppressUncaughtExceptions;
//# sourceMappingURL=process.js.map