"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeferred = void 0;
/**
 * It creates outside controlled promise so you can do the resole and reject outside the Promise constructor callback.
 * In standard Promise instantiating, you have to do all logic inside the constructor callback.
 */
function createDeferred() {
    const deferred = {};
    const promise = new Promise((resolve, reject) => {
        deferred.resolve = resolve;
        deferred.reject = reject;
    });
    deferred.promise = promise;
    return deferred;
}
exports.createDeferred = createDeferred;
//# sourceMappingURL=deferred.js.map