"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unescape = exports.escape = exports.unescapeObject = exports.escapeObject = void 0;
const lodash_1 = require("lodash");
function escapeObject(object) {
    return recureObject(object, escape);
}
exports.escapeObject = escapeObject;
function unescapeObject(object) {
    return recureObject(object, unescape);
}
exports.unescapeObject = unescapeObject;
function recureObject(recuringObject, callback) {
    return (0, lodash_1.isPlainObject)(recuringObject)
        ? Object.keys(recuringObject).reduce((reductionObject, key) => {
            const updatedKey = callback(key);
            const subObject = reductionObject[key];
            const updatedSubObject = recureObject(subObject, callback);
            if (key !== updatedKey || subObject !== updatedSubObject) {
                const omittedObject = (0, lodash_1.omit)(reductionObject, key);
                return Object.assign(Object.assign({}, omittedObject), { [updatedKey]: updatedSubObject });
            }
            else {
                return reductionObject;
            }
        }, recuringObject)
        : recuringObject;
}
function escape(key) {
    return isEscapable(key) ? key.replace(/\$/g, '\uFF04').replace(/\./g, '\uFF0E') : key;
}
exports.escape = escape;
function unescape(key) {
    return isUnescapable(key) ? key.replace(/\uFF04/g, '$').replace(/\uFF0E/g, '.') : key;
}
exports.unescape = unescape;
function isEscapable(key) {
    return key.indexOf('$') !== -1 || key.indexOf('.') !== -1;
}
function isUnescapable(key) {
    return key.indexOf('\uFF04') !== -1 || key.indexOf('\uFF0E') !== -1;
}
//# sourceMappingURL=escape.js.map