"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.lowReadLatency = void 0;
const helper_1 = require("../helper");
const timeout_1 = require("../../../Timer/timeout");
const READ_LATENCY_TIMEOUT = 5e3;
function lowReadLatency(parsedDsn, _originalDsn) {
    return __awaiter(this, void 0, void 0, function* () {
        const nodeLatencies = yield Promise.allSettled(parsedDsn.hosts.map((host) => __awaiter(this, void 0, void 0, function* () {
            return ({
                host,
                latency: yield (0, timeout_1.withTimeout)(getNodeReadsLatency(host, parsedDsn), READ_LATENCY_TIMEOUT),
            });
        })));
        const succeededLatencies = nodeLatencies
            .filter((latency) => latency.status === 'fulfilled')
            .map((latency) => latency.value);
        succeededLatencies.sort((a, b) => a.latency - b.latency); // mutable sort
        const minLatency = succeededLatencies[0];
        const selectedDsn = (0, helper_1.getDsn)(minLatency.host, parsedDsn);
        return selectedDsn;
    });
}
exports.lowReadLatency = lowReadLatency;
function getNodeReadsLatency(host, parameters) {
    return __awaiter(this, void 0, void 0, function* () {
        return (0, helper_1.doConnectionCallback)(host, parameters, (connection) => __awaiter(this, void 0, void 0, function* () {
            const status = yield connection.db(parameters.endpoint).admin().serverStatus();
            return status.opLatencies.reads.latency;
        }));
    });
}
//# sourceMappingURL=lowReadLatency.js.map