import * as mongoose from 'mongoose';
import { MongoDBDriverExporter } from '../Metrics/mongoDBDriverExporter';
import { IMongodbConnection } from './mongoDBConnectionFactory';
export declare class MongoDBConnection implements IMongodbConnection {
    private mongoDbDsn;
    connection: mongoose.Connection | null;
    private options;
    private gracefulExit;
    private metrics;
    constructor(mongoDbDsn: string, options?: mongoose.ConnectOptions, onExit?: () => void);
    connect(): Promise<void>;
    close(): Promise<void>;
    monitor(exporter: MongoDBDriverExporter, connectionName: string): void;
    private applyGracefulExit;
    /**
     * @see https://www.mongodb.com/docs/drivers/node/current/fundamentals/monitoring/command-monitoring/#command-monitoring
     */
    private monitorConnection;
}
