"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRavenLogging = void 0;
const Raven = require("raven");
function useRavenLogging() {
    // override default console logging
    const consoleWarn = console.warn;
    const consoleError = console.error;
    console.warn = (message, ...optionalParams) => {
        consoleWarn.call(console, message, ...optionalParams);
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven('warning', 'warn', message, ...optionalParams);
        }
    };
    console.error = (message, ...optionalParams) => {
        consoleError.call(console, message, ...optionalParams);
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven('error', 'error', message, ...optionalParams);
        }
    };
}
exports.useRavenLogging = useRavenLogging;
function captureRaven(level, source, message, ...optionalParams) {
    const options = {
        level,
        tags: {
            source,
        },
        extra: optionalParams,
    };
    if (message instanceof Error) {
        Raven.captureException(message, options);
    }
    else {
        if (typeof message === 'string') {
            message = message;
        }
        else {
            message = JSON.stringify(message);
        }
        Raven.captureMessage(message, options);
    }
}
//# sourceMappingURL=raven.js.map