import { WinstonLogger } from './logger';
/**
 * Singleton logger to be used across the entire application
 */
export declare const logger: WinstonLogger;
/**
 * This function will redirect all console logs and debug logs to the logger.
 *
 * The goal is to collect all logs that are not logged through the central logger and make them go through the logger.
 * That way we can control the format and destination of all logs no matter where they are logged.
 */
export declare function redirectAllLogsToLogger(): void;
