"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.locked = void 0;
const AsyncLock = require("async-lock");
const util = require("util");
const globalAsyncLock = new AsyncLock();
const asyncLocksMap = new WeakMap();
function acquireAsyncLock(options, instance) {
    if ((options === null || options === void 0 ? void 0 : options.scope) === undefined || (options === null || options === void 0 ? void 0 : options.scope) === 'global') {
        return globalAsyncLock;
    }
    else if ((options === null || options === void 0 ? void 0 : options.scope) === 'instance') {
        if (asyncLocksMap.has(instance)) {
            const lock = asyncLocksMap.get(instance);
            lock.countRunning++;
            return lock.asyncLock;
        }
        else {
            const asyncLock = new AsyncLock();
            asyncLocksMap.set(instance, { countRunning: 1, asyncLock });
            return asyncLock;
        }
    }
    throw new Error(`Invalid option scope=${options === null || options === void 0 ? void 0 : options.scope}`);
}
function releaseAsyncLock(options, instance) {
    if ((options === null || options === void 0 ? void 0 : options.scope) === 'instance') {
        const lock = asyncLocksMap.get(instance);
        lock.countRunning--;
        if (lock.countRunning === 0) {
            asyncLocksMap.delete(instance);
        }
    }
}
function locked(keyInitiator, options) {
    return function (_target, _propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = typeof keyInitiator === 'function' ? keyInitiator.call(this, ...args) : keyInitiator;
                const currentAsyncLock = acquireAsyncLock(options, this);
                try {
                    return yield currentAsyncLock.acquire(key, () => __awaiter(this, void 0, void 0, function* () {
                        const returnValuePromise = originalMethod.apply(this, args);
                        if (!(returnValuePromise instanceof Promise)) {
                            throw new Error(`Synchronous methods must return Promise instance. But ${util.inspect(returnValuePromise)} given.`);
                        }
                        return yield returnValuePromise;
                    }), options);
                }
                finally {
                    releaseAsyncLock(options, this);
                }
            });
        };
    };
}
exports.locked = locked;
//# sourceMappingURL=lockedDecorator.js.map