"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const wait_1 = require("../Timer/wait");
const time = require("../DateTime/dateTimeFactory");
const generator_1 = require("../Hash/generator");
function default_1(connections, checkStatus, label, serviceUid) {
    return (timeout) => __awaiter(this, void 0, void 0, function* () {
        const servicesResponses = {};
        yield Promise.all(connections.map((conn, index) => __awaiter(this, void 0, void 0, function* () {
            const requestedAt = time.now();
            try {
                const responseData = yield Promise.race([
                    checkStatus(conn, `${serviceUid}_${index}_${(0, generator_1.generateUniqueHash)(6)}`),
                    (0, wait_1.default)(timeout).then(() => Promise.reject(new Error(`Status check timed-out`))),
                ]);
                const respondedAt = time.now();
                servicesResponses[label + index] = {
                    response: Object.assign({ requestedAt: requestedAt.valueOf(), respondedAt: respondedAt.valueOf(), responseTime: respondedAt.diff(requestedAt).valueOf() }, responseData),
                };
            }
            catch (error) {
                const failedAt = time.now();
                servicesResponses[label + index] = {
                    error: {
                        message: error.message,
                        requestedAt: requestedAt.valueOf(),
                        failedAt: failedAt.valueOf(),
                        errorTime: failedAt.diff(requestedAt).valueOf(),
                    },
                };
            }
        })));
        return servicesResponses;
    });
}
exports.default = default_1;
//# sourceMappingURL=status.js.map