"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AMQP_LABEL = void 0;
exports.AMQP_LABEL = 'amqp';
function default_1(amqpConnection, uid) {
    return __awaiter(this, void 0, void 0, function* () {
        const HEALTH_STATUS_QUEUE = `___${uid}_health_status_queue`;
        const HEALTH_STATUS_MESSAGE = `${uid}_health_status_test_message`;
        const connection = yield amqpConnection.pool.acquire();
        try {
            const channel = yield connection.createChannel();
            try {
                yield channel.assertQueue(HEALTH_STATUS_QUEUE, {
                    durable: false,
                    autoDelete: true,
                    exclusive: true,
                    expires: 5 * 60 * 1000, // expire after 5 minutes
                });
                channel.sendToQueue(HEALTH_STATUS_QUEUE, new Buffer(HEALTH_STATUS_MESSAGE));
                const msg = yield channel.get(HEALTH_STATUS_QUEUE, { noAck: true });
                if (typeof msg === 'boolean') {
                    throw new Error(`No messages in ${HEALTH_STATUS_QUEUE} to be received.`);
                }
                else if (HEALTH_STATUS_MESSAGE !== msg.content.toString()) {
                    throw new Error(`Message sent to ${HEALTH_STATUS_QUEUE} differs compare to message consumed from queue.\n
					Sent: ${HEALTH_STATUS_MESSAGE}\n
					Received: ${msg.content.toString()}`);
                }
                yield channel.deleteQueue(HEALTH_STATUS_QUEUE);
                return {};
            }
            finally {
                yield channel.close();
            }
        }
        finally {
            yield amqpConnection.pool.release(connection);
        }
    });
}
exports.default = default_1;
//# sourceMappingURL=amqpStatusCheck.js.map