"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getModuleExportsRecursive = exports.getStringValuesRecursive = void 0;
const fs = require("fs");
function getStringValuesRecursive(path) {
    const dirs = fs.readdirSync(path);
    let values = [];
    for (let dir of dirs) {
        const filePath = path + '/' + dir;
        const stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            values = [...values, ...getStringValuesRecursive(filePath)];
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            const module = require(filePath);
            for (let name in module) {
                if (typeof module[name] === 'string') {
                    values = [...values, module[name]];
                }
            }
        }
    }
    return values;
}
exports.getStringValuesRecursive = getStringValuesRecursive;
function getModuleExportsRecursive(path, relativeBasePath = '.') {
    const dirs = fs.readdirSync(path);
    let moduleExports = [];
    for (let dir of dirs) {
        const filePath = path + '/' + dir;
        const stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            moduleExports = [...moduleExports, ...getModuleExportsRecursive(filePath, relativeBasePath + '/' + dir)];
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            const relativePath = relativeBasePath + '/' + dir.substr(0, dir.lastIndexOf('.'));
            const module = require(filePath);
            for (let name in module) {
                moduleExports = [
                    ...moduleExports,
                    {
                        relativePath,
                        export: name,
                        value: module[name],
                    },
                ];
            }
        }
    }
    return moduleExports;
}
exports.getModuleExportsRecursive = getModuleExportsRecursive;
//# sourceMappingURL=moduleDiscoverer.js.map