"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericGracefulExit = void 0;
const events_1 = require("events");
const Debug = require("debug");
const eventsHelpers_1 = require("./eventsHelpers");
const debug = Debug('@signageos/lib:Events:genericGracefulExit');
class GenericGracefulExit {
    constructor(serviceName, timeout = 30e3, exitStrategy = () => process.exit(1)) {
        this.serviceName = serviceName;
        this.timeout = timeout;
        this.emitter = new events_1.EventEmitter();
        this.waitForSuccessOrFailPromise = null;
        this.exitStrategy = exitStrategy;
    }
    waitToConnectOrDie() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.waitForSuccessOrFailPromise) {
                debug('%s waits to connect, timeout is %d', this.serviceName, this.timeout);
                // turns align rule off
                this.waitForSuccessOrFailPromise = (0, eventsHelpers_1.waitForSuccessEventsOrFailEvent)(this.emitter, ['connected_ok', 'closed_ok'], 'timeout');
                const timeout = setTimeout(() => {
                    debug('if %s does not connect it will be terminated in %d', this.serviceName, this.timeout);
                    this.exitStrategy();
                    this.closed();
                }, this.timeout);
                this.waitForSuccessOrFailPromise.then(() => clearTimeout(timeout));
            }
            return this.waitForSuccessOrFailPromise;
        });
    }
    connected() {
        this.emitter.emit('connected_ok');
        this.waitForSuccessOrFailPromise = null;
        debug('%s connected', this.serviceName);
    }
    closed() {
        this.emitter.emit('closed_ok');
        this.waitForSuccessOrFailPromise = null;
        debug('%s closed', this.serviceName);
    }
}
exports.GenericGracefulExit = GenericGracefulExit;
//# sourceMappingURL=genericGracefulExit.js.map