"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.svgrPlugin = void 0;
const core_1 = require("@svgr/core");
const fs = require("fs");
const path = require("path");
const svgrPlugin = () => ({
    name: 'svgr',
    setup(build) {
        return __awaiter(this, void 0, void 0, function* () {
            build.onResolve({ filter: /\.svg$/ }, (args) => ({
                path: path.resolve(args.resolveDir, args.path),
                namespace: 'svgr',
            }));
            build.onLoad({ filter: /.*/, namespace: 'svgr' }, (args) => __awaiter(this, void 0, void 0, function* () {
                const svg = (yield fs.promises.readFile(args.path)).toString('utf-8');
                const fileName = path.basename(args.path, '.svg');
                const componentName = fileName.charAt(0).toUpperCase() + fileName.slice(1);
                const contents = yield (0, core_1.transform)(svg, { icon: true, plugins: ['@svgr/plugin-jsx'] }, { componentName });
                return {
                    contents,
                    loader: 'jsx',
                    resolveDir: process.cwd(),
                };
            }));
        });
    },
});
exports.svgrPlugin = svgrPlugin;
//# sourceMappingURL=svgr.js.map