export interface ParseConfigArgs {
    basePath?: string;
    addToProcessEnv?: boolean;
}
/**
 * Parses environment variables and package.json into a config object for generic applications
 *
 * @param args - optionally not load process.env for testing purposes, leave undefined in application code
 * @returns basic config object that can be used by any NodeJS application
 */
export declare function parseBasicConfig(args?: ParseConfigArgs): {
    environment: string;
    paths: {
        rootPath: string;
        configPath: string;
        testsPath: string;
        toolsPath: string;
        distPath: string;
    };
    app: {
        /**
         * Parsed out of package name in package.json
         * @example @signageos/api -> api
         */
        name: string;
        version: string;
    };
    npm: {
        name: string;
        version: string;
        dependencies: Record<string, string>;
        devDependencies: Record<string, string>;
        peerDependencies: Record<string, string>;
        optionalPeerDependencies: Record<string, string>;
        gitHead?: string | undefined;
    };
    sentry: {
        enabled: boolean;
        config: {
            dsn: string;
            release: string;
            environment: string;
            tags: {
                application: string;
                git_commit: string;
            };
        };
    };
};
export type BasicConfig = ReturnType<typeof parseBasicConfig>;
/**
 * Parses environment variables and package.json into a config object for services
 *
 * Extends parseBasicConfig to include env vars for services
 *
 * @param args - optionally not load process.env for testing purposes, leave undefined in application code
 * @returns basic config object that can be used by any NodeJS application
 */
export declare function parseServiceConfig(args?: ParseConfigArgs): {
    environment: string;
    paths: {
        rootPath: string;
        configPath: string;
        testsPath: string;
        toolsPath: string;
        distPath: string;
    };
    app: {
        /**
         * Parsed out of package name in package.json
         * @example @signageos/api -> api
         */
        name: string;
        version: string;
    };
    npm: {
        name: string;
        version: string;
        dependencies: Record<string, string>;
        devDependencies: Record<string, string>;
        peerDependencies: Record<string, string>;
        optionalPeerDependencies: Record<string, string>;
        gitHead?: string | undefined;
    };
    sentry: {
        enabled: boolean;
        config: {
            dsn: string;
            release: string;
            environment: string;
            tags: {
                application: string;
                git_commit: string;
            };
        };
    };
} & {
    app: {
        port: number;
        monitoringPort: number;
    };
};
export type ServiceConfig = ReturnType<typeof parseServiceConfig>;
