"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const queueConfigurator_1 = require("./queueConfigurator");
const jsonHelper_1 = require("../JSON/jsonHelper");
function fetchNextMessage(amqpConnection, queueName, routingKey, exchangeName = '', alternateExchangeName = '', options = {}, exchangeType = 'topic', alternateExchangeType = 'topic') {
    return __awaiter(this, void 0, void 0, function* () {
        if (exchangeName === '' && queueName !== routingKey) {
            throw new Error('If default exchange is used, queue name must match the routing key');
        }
        const connection = yield amqpConnection.pool.acquire(options.priority);
        try {
            const channel = yield connection.createConfirmChannel();
            if (exchangeName !== '') {
                if (alternateExchangeName !== '') {
                    yield channel.assertExchange(alternateExchangeName, alternateExchangeType);
                    yield channel.assertExchange(exchangeName, exchangeType, {
                        alternateExchange: alternateExchangeName,
                    });
                }
                else {
                    yield channel.assertExchange(exchangeName, exchangeType);
                }
            }
            yield (0, queueConfigurator_1.assertRejectableQueue)(channel, queueName, options.maxPriority, options.durable, options.singleActiveConsumer, options.deadLetterExchange, options.deadLetterRoutingKey, options.queueType);
            if (exchangeName !== '') {
                yield channel.bindQueue(queueName, exchangeName, routingKey);
            }
            const message = yield channel.get(queueName, { noAck: true });
            yield channel.close();
            yield amqpConnection.pool.release(connection);
            if (message && typeof message !== 'boolean') {
                return message.content ? JSON.parse(message.content.toString(), jsonHelper_1.deserializeJSON) : null;
            }
            else {
                return null;
            }
        }
        catch (error) {
            yield amqpConnection.pool.destroy(connection);
            throw error;
        }
    });
}
exports.default = fetchNextMessage;
//# sourceMappingURL=fetchNextMessage.js.map