import { IAMQPConnection } from './amqpConnectionFactory';
import { ExchangeType } from './Exchange';
export default function fetchNextMessage<TMessage>(amqpConnection: IAMQPConnection, queueName: string, routingKey: string, exchangeName?: string, alternateExchangeName?: string, options?: {
    priority?: number;
    maxPriority?: number;
    durable?: boolean;
    singleActiveConsumer?: boolean;
    deadLetterExchange?: string;
    deadLetterRoutingKey?: string;
    queueType?: 'quorum' | 'classic';
}, exchangeType?: ExchangeType, alternateExchangeType?: ExchangeType): Promise<TMessage | null>;
