"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareAll = exports.deleteAll = exports.purgeAll = exports.fetchNextAggregatedCommand = exports.bindAggregatedCommands = exports.markAggregatedCommandFailed = exports.markAggregatedCommandSucceeded = exports.fetchNextStoredCommand = exports.bindStoredCommands = exports.createStoredCommand = exports.AGGREGATED_QUEUE_NAME = exports.STORED_QUEUE_NAME = void 0;
const fetchNextMessage_1 = require("../fetchNextMessage");
exports.STORED_QUEUE_NAME = 'stored_commands';
exports.AGGREGATED_QUEUE_NAME = 'aggregated_commands';
const OPTIONS = {
    persistent: true,
    confirmable: false,
};
const MESSAGE_OPTIONS = {
    persistent: false, // messages are not written to disc
};
function createStoredCommand(amqpConnection, command) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(exports.STORED_QUEUE_NAME, 'fanout');
            return channel;
        });
        yield amqpConnection.queuePublisher.enqueue(createChannel, command, undefined, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, MESSAGE_OPTIONS);
    });
}
exports.createStoredCommand = createStoredCommand;
function bindStoredCommands(amqpConnection, onCommand) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(exports.STORED_QUEUE_NAME, 'fanout');
            return channel;
        }), exports.STORED_QUEUE_NAME, [{ exchangeName: exports.STORED_QUEUE_NAME, routingKey: exports.STORED_QUEUE_NAME, persistent: true }], onCommand, { autoDelete: false, durable: false });
    });
}
exports.bindStoredCommands = bindStoredCommands;
function fetchNextStoredCommand(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield (0, fetchNextMessage_1.default)(amqpConnection, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, undefined, undefined, 'fanout');
    });
}
exports.fetchNextStoredCommand = fetchNextStoredCommand;
function markAggregatedCommandSucceeded(amqpConnection, command, succeededAt) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout');
            return channel;
        });
        const aggregatedCommand = {
            commandId: command.id,
            succeededAt,
        };
        yield amqpConnection.queuePublisher.enqueue(createChannel, aggregatedCommand, undefined, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, MESSAGE_OPTIONS);
    });
}
exports.markAggregatedCommandSucceeded = markAggregatedCommandSucceeded;
function markAggregatedCommandFailed(amqpConnection, command, failedAt, error) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout');
            return channel;
        });
        const aggregatedCommand = {
            commandId: command.id,
            failedAt,
            error,
        };
        yield amqpConnection.queuePublisher.enqueue(createChannel, aggregatedCommand, undefined, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, MESSAGE_OPTIONS);
    });
}
exports.markAggregatedCommandFailed = markAggregatedCommandFailed;
function bindAggregatedCommands(amqpConnection, onCommand) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout');
            return channel;
        }), exports.AGGREGATED_QUEUE_NAME, [{ exchangeName: exports.AGGREGATED_QUEUE_NAME, routingKey: exports.AGGREGATED_QUEUE_NAME, persistent: true }], (aggregatedCommand, _headers, ack, nack) => onCommand(aggregatedCommand, ack, nack), { autoDelete: false, durable: false });
    });
}
exports.bindAggregatedCommands = bindAggregatedCommands;
function fetchNextAggregatedCommand(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield (0, fetchNextMessage_1.default)(amqpConnection, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, undefined, undefined, 'fanout');
    });
}
exports.fetchNextAggregatedCommand = fetchNextAggregatedCommand;
function purgeAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const channel = yield amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME);
        try {
            yield channel.purge(exports.STORED_QUEUE_NAME);
            yield channel.purge(exports.AGGREGATED_QUEUE_NAME);
        }
        finally {
            yield channel.close();
        }
    });
}
exports.purgeAll = purgeAll;
function deleteAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const channel = yield amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME);
        try {
            yield channel.delete(exports.STORED_QUEUE_NAME);
            yield channel.delete(exports.AGGREGATED_QUEUE_NAME);
        }
        finally {
            yield channel.close();
        }
    });
}
exports.deleteAll = deleteAll;
function prepareAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        // Hack to create event queue for exchange
        yield fetchNextStoredCommand(amqpConnection);
        yield fetchNextAggregatedCommand(amqpConnection);
    });
}
exports.prepareAll = prepareAll;
//# sourceMappingURL=storedCommandQueue.js.map