"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var io = require("socket.io-client");
var url = require("url");
function createSocket(socketUri, onConnected, onDisconnected, onError) {
    var parsedSocketUrl = url.parse(socketUri);
    var pathname = parsedSocketUrl.pathname;
    var socketUrl = parsedSocketUrl.protocol + '//' + parsedSocketUrl.host;
    var socketIoPath = (pathname + '/socket.io').replace(/\/+/g, '/');
    var socket = io(socketUrl, {
        path: socketIoPath,
        forceNew: true,
        upgrade: false,
        rememberUpgrade: true,
        transports: ['websocket'],
        reconnection: false,
        timeout: 5e3,
    });
    socket.on('connect_error', function (error) { return onError(error); });
    socket.on('error', function (error) { return onError(error); });
    socket.on('connection', function () { return onConnected(); });
    socket.on('disconnect', function () { return onDisconnected(); });
    return {
        on: function (event, listener) {
            socket.on(event, function (message, callback) {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        once: function (event, listener) {
            socket.once(event, function (message, callback) {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        emit: function (event, message, callback) {
            socket.emit(event, message, callback);
        },
        removeListener: function (event, listener) {
            socket.off(event, listener);
        },
        removeAllListeners: function () {
            socket.removeAllListeners();
        },
        close: function () {
            socket.close();
        },
    };
}
exports.default = createSocket;
//# sourceMappingURL=createSocketIOSocket.js.map