"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppExpress = void 0;
var express = require("express");
var accessLogMiddleware_1 = require("../middleware/accessLogMiddleware");
var logging_1 = require("../../../Logging/logging");
var router_1 = require("../routes/app/router");
var expressFactory_1 = require("./expressFactory");
var accessLogLogger = logging_1.logger.createNamespace('accessLog');
function createAppExpress(args) {
    var accessLogCallback = args.accessLogCallback;
    var app = (0, expressFactory_1.createExpressApp)();
    // Log all requests
    app.use((0, accessLogMiddleware_1.accessLogMiddleware)(function (accessLog, req, res) {
        accessLogLogger.info("".concat(accessLog.method, " ").concat(accessLog.path), __assign(__assign({}, accessLog), accessLogCallback === null || accessLogCallback === void 0 ? void 0 : accessLogCallback(accessLog, req, res)));
    }));
    var router = express.Router();
    (0, router_1.routeApp)(__assign(__assign({}, args), { router: router }));
    app.use('/', router);
    return app;
}
exports.createAppExpress = createAppExpress;
//# sourceMappingURL=app.js.map