"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dynamicPriority = void 0;
var helper_1 = require("../helper");
var timeout_1 = require("../../../Timer/timeout");
var GET_PRIORITY_TIMEOUT = 5e3;
var EXTRA_OPTIONS = ['proprietaryPriorityPath'];
function dynamicPriority(parsedDsn, originalDsn) {
    return __awaiter(this, void 0, void 0, function () {
        var items, _i, _a, host, priority, error_1, priorityItem, selectedDsn;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    items = [];
                    _i = 0, _a = parsedDsn.hosts;
                    _b.label = 1;
                case 1:
                    if (!(_i < _a.length)) return [3 /*break*/, 6];
                    host = _a[_i];
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, (0, timeout_1.withTimeout)(getPriority(host, parsedDsn), GET_PRIORITY_TIMEOUT)];
                case 3:
                    priority = _b.sent();
                    items.push({ host: host, priority: priority });
                    return [3 /*break*/, 5];
                case 4:
                    error_1 = _b.sent();
                    console.error('Not available host', host, error_1);
                    return [3 /*break*/, 5];
                case 5:
                    _i++;
                    return [3 /*break*/, 1];
                case 6:
                    priorityItem = items.reduce(function (acc, item) { return (!acc || item.priority > acc.priority ? item : acc); }, null);
                    if (!priorityItem) {
                        throw new Error("No available connection string (DSN) found: ".concat(originalDsn));
                    }
                    selectedDsn = (0, helper_1.getDsn)(priorityItem.host, parsedDsn, EXTRA_OPTIONS);
                    return [2 /*return*/, selectedDsn];
            }
        });
    });
}
exports.dynamicPriority = dynamicPriority;
function getPriority(host, parameters) {
    return __awaiter(this, void 0, void 0, function () {
        var simplifiedParameters;
        var _this = this;
        return __generator(this, function (_a) {
            simplifiedParameters = (0, helper_1.withoutOptions)(parameters, EXTRA_OPTIONS);
            return [2 /*return*/, (0, helper_1.doConnectionCallback)(host, simplifiedParameters, function (connection) { return __awaiter(_this, void 0, void 0, function () {
                    var proprietaryPriorityPath, _a, collectionName, key, settings;
                    var _b, _c, _d;
                    return __generator(this, function (_e) {
                        switch (_e.label) {
                            case 0:
                                proprietaryPriorityPath = (_c = (_b = parameters.options) === null || _b === void 0 ? void 0 : _b.proprietaryPriorityPath) !== null && _c !== void 0 ? _c : 'proprietaryClusterSettings.priority';
                                _a = proprietaryPriorityPath.split('.'), collectionName = _a[0], key = _a[1];
                                return [4 /*yield*/, connection.db(parameters.endpoint).collection(collectionName).findOne({})];
                            case 1:
                                settings = _e.sent();
                                return [2 /*return*/, (_d = settings === null || settings === void 0 ? void 0 : settings[key]) !== null && _d !== void 0 ? _d : 0];
                        }
                    });
                }); })];
        });
    });
}
//# sourceMappingURL=dynamicPriority.js.map