import type { MongoClient } from 'mongodb';
import { type Registry } from 'prom-client';
export interface MongoDBDriverExporterOptions {
    /**
     * Buckets for the mongodb_driver_commands_seconds_bucket metric.
     * Default buckets are [0.001, 0.005, 0.010, 0.020, 0.030, 0.040, 0.050, 0.100, 0.200, 0.500, 1.0, 2.0, 5.0, 10]
     */
    mongodbDriverCommandsSecondsHistogramBuckets?: number[];
}
/**
 * Exports metrics for the MongoDB driver
 *
 * It has to be a singleton because it registers the metrics in the global registry
 * and it's not possible to register the same metric multiple times.
 */
export declare class MongoDBDriverExporter {
    private readonly register;
    private readonly options;
    private readonly poolSize;
    private readonly minSize;
    private readonly maxSize;
    private readonly active;
    private readonly wait;
    private readonly commandsHistogram;
    private readonly failedCommands;
    constructor(register: Registry, options?: MongoDBDriverExporterOptions);
    /**
     * Start monitoring the given mongo client instance
     *
     * @param mongoClient mongo client instance
     * @param name unique name for the client that will be used as a label to differentiate between multiple clients
     */
    monitorMongoClient(mongoClient: MongoClient, name: string): void;
    private onConnectionPoolCreated;
    private onConnectionCreated;
    private onConnectionClosed;
    private onConnectionCheckOutStarted;
    private onConnectionCheckedOut;
    private onConnectionCheckOutFailed;
    private onConnectionCheckedIn;
    private onConnectionPoolClosed;
    private onCommandSucceeded;
    private onCommandFailed;
}
