"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptPassword = exports.preEncryptPassword = void 0;
var crypto_1 = require("crypto");
var ts_brand_1 = require("ts-brand");
var PreEncryptedPassword = (0, ts_brand_1.make)();
function preEncryptPassword(plainPassword) {
    var salt = '10a34637ad661d98ba3344717656fcc76209c2f8';
    var hash = (0, crypto_1.createHash)('sha256');
    hash.update(plainPassword + salt);
    return PreEncryptedPassword(hash.digest('hex'));
}
exports.preEncryptPassword = preEncryptPassword;
function encryptPassword(plainPassword, salt) {
    if (plainPassword.length !== 64) {
        throw new Error('Password must be pre-encrypted using preEncryptPassword function to be 64 characters long');
    }
    return new Promise(function (resolve, reject) {
        return (0, crypto_1.pbkdf2)(plainPassword, salt, 100000, 512, 'sha512', function (error, key) {
            if (error) {
                reject(error);
            }
            else {
                resolve(key.toString('hex').substring(0, 64));
            }
        });
    });
}
exports.encryptPassword = encryptPassword;
//# sourceMappingURL=passwordEncryption.js.map