"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.packDist = void 0;
var fs = require("fs-extra");
var path = require("path");
var child_process_1 = require("child_process");
var util = require("util");
var tmp = require("tmp");
var tar = require("tar");
var execPromise = util.promisify(child_process_1.exec);
var packDist = function (options) { return __awaiter(void 0, void 0, void 0, function () {
    var timestampNumber, devVersion, tmpDir, configPath, configContents, tarballDir, tarballFileName;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!(options.environment === 'dev')) return [3 /*break*/, 8];
                timestampNumber = new Date().toISOString().replace(/[^\d]/gi, '').substr(0, 14);
                devVersion = (options.getVersion ? options.getVersion() : '99.0.0-dev') + '.' + timestampNumber;
                tmpDir = tmp.dirSync().name;
                return [4 /*yield*/, fs.copy(path.join(options.rootPath, 'dist'), path.join(tmpDir, 'package', 'dist'))];
            case 1:
                _a.sent();
                return [4 /*yield*/, fs.copy(path.join(options.rootPath, 'README.md'), path.join(tmpDir, 'package', 'README.md'))];
            case 2:
                _a.sent();
                configPath = path.join(options.rootPath, 'package.json');
                return [4 /*yield*/, fs.readJson(configPath)];
            case 3:
                configContents = _a.sent();
                configContents.version = devVersion;
                return [4 /*yield*/, fs.writeJson(path.join(tmpDir, 'package', 'package.json'), configContents, { spaces: 2 })];
            case 4:
                _a.sent();
                tarballDir = path.join(options.packagesPath, options.name, devVersion);
                tarballFileName = options.name.replace(/^@/, '').replace(/\//g, '-') + '-' + devVersion + '.tgz';
                return [4 /*yield*/, fs.ensureDir(tarballDir)];
            case 5:
                _a.sent();
                return [4 /*yield*/, tar.c({
                        gzip: true,
                        file: path.join(tarballDir, tarballFileName),
                        cwd: tmpDir,
                    }, ['package'])];
            case 6:
                _a.sent();
                return [4 /*yield*/, packDependencies(options)];
            case 7:
                _a.sent();
                console.info('Tarball release ' + tarballFileName);
                _a.label = 8;
            case 8: return [2 /*return*/];
        }
    });
}); };
exports.packDist = packDist;
function packDependencies(options) {
    return __awaiter(this, void 0, void 0, function () {
        var configLockPath, configLockContents, dependencies, _i, dependencies_1, dependency, dependencyVersion, dependencyVersionPath, stdout, fileName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    configLockPath = path.join(options.rootPath, 'package-lock.json');
                    return [4 /*yield*/, fs.readJson(configLockPath)];
                case 1:
                    configLockContents = _a.sent();
                    dependencies = options.dependencies || [];
                    _i = 0, dependencies_1 = dependencies;
                    _a.label = 2;
                case 2:
                    if (!(_i < dependencies_1.length)) return [3 /*break*/, 8];
                    dependency = dependencies_1[_i];
                    dependencyVersion = 'dependencies' in configLockContents
                        ? // lockfileVersion 0 and 1
                            configLockContents.dependencies[dependency].version
                        : // lockfileVersion 2 and 3
                            configLockContents.packages['node_modules/' + dependency].version;
                    dependencyVersionPath = path.join(options.packagesPath, dependency, dependencyVersion);
                    return [4 /*yield*/, fs.pathExists(dependencyVersionPath)];
                case 3:
                    if (!!(_a.sent())) return [3 /*break*/, 7];
                    return [4 /*yield*/, execPromise("npm pack ".concat(dependency, "@").concat(dependencyVersionPath))];
                case 4:
                    stdout = (_a.sent()).stdout;
                    fileName = stdout.trim();
                    return [4 /*yield*/, fs.ensureDir(dependencyVersionPath)];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, fs.move(path.join(options.rootPath, fileName), path.join(dependencyVersionPath, fileName))];
                case 6:
                    _a.sent();
                    _a.label = 7;
                case 7:
                    _i++;
                    return [3 /*break*/, 2];
                case 8: return [2 /*return*/];
            }
        });
    });
}
//# sourceMappingURL=pack.js.map