"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncDelegator = (this && this.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
};
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.walk = exports.transpileToES5 = exports.transpileFiles = exports.resolveConfig = exports.printBanner = exports.handleWatchMode = exports.handleBuildMode = exports.buffer = exports.addLiveReloading = void 0;
var core_1 = require("@swc/core");
var debugFunc = require("debug");
var fs = require("fs");
var path = require("path");
var IBundler_1 = require("../IBundler");
var debug = debugFunc('@signageos/lib:Bundler');
function addLiveReloading(source, dest, origin) {
    if (origin === void 0) { origin = ''; }
    return __awaiter(this, void 0, void 0, function () {
        var indexFile;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fs.promises.readFile(source)];
                case 1:
                    indexFile = _a.sent();
                    return [4 /*yield*/, fs.promises.writeFile(dest, indexFile
                            .toString('utf-8')
                            .replace('</body>', "<script>new EventSource(\"".concat(origin, "/esbuild\").addEventListener('change', () => location.reload())</script></body>")))];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.addLiveReloading = addLiveReloading;
// Buffers async iteratable to array
function buffer(iterable) {
    var _a, iterable_1, iterable_1_1;
    var _b, e_1, _c, _d;
    return __awaiter(this, void 0, void 0, function () {
        var buf, x, e_1_1;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    buf = [];
                    _e.label = 1;
                case 1:
                    _e.trys.push([1, 6, 7, 12]);
                    _a = true, iterable_1 = __asyncValues(iterable);
                    _e.label = 2;
                case 2: return [4 /*yield*/, iterable_1.next()];
                case 3:
                    if (!(iterable_1_1 = _e.sent(), _b = iterable_1_1.done, !_b)) return [3 /*break*/, 5];
                    _d = iterable_1_1.value;
                    _a = false;
                    try {
                        x = _d;
                        buf.push(x);
                    }
                    finally {
                        _a = true;
                    }
                    _e.label = 4;
                case 4: return [3 /*break*/, 2];
                case 5: return [3 /*break*/, 12];
                case 6:
                    e_1_1 = _e.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 12];
                case 7:
                    _e.trys.push([7, , 10, 11]);
                    if (!(!_a && !_b && (_c = iterable_1.return))) return [3 /*break*/, 9];
                    return [4 /*yield*/, _c.call(iterable_1)];
                case 8:
                    _e.sent();
                    _e.label = 9;
                case 9: return [3 /*break*/, 11];
                case 10:
                    if (e_1) throw e_1.error;
                    return [7 /*endfinally*/];
                case 11: return [7 /*endfinally*/];
                case 12: return [2 /*return*/, buf];
            }
        });
    });
}
exports.buffer = buffer;
function handleBuildMode(ctx) {
    return __awaiter(this, void 0, void 0, function () {
        var metafile;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log('ESBuild is rebuilding...');
                    return [4 /*yield*/, ctx.rebuild()];
                case 1:
                    metafile = (_a.sent()).metafile;
                    if (metafile) {
                        fs.promises.writeFile('./meta.json', JSON.stringify(metafile));
                    }
                    return [4 /*yield*/, ctx.dispose()];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.handleBuildMode = handleBuildMode;
function handleWatchMode(ctx, mode, serveOptions) {
    return __awaiter(this, void 0, void 0, function () {
        var port;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.info('ESBuild is watching...');
                    return [4 /*yield*/, ctx.rebuild()];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, ctx.watch()];
                case 2:
                    _a.sent();
                    if (!(mode === 'serve')) return [3 /*break*/, 4];
                    return [4 /*yield*/, ctx.serve(serveOptions)];
                case 3:
                    port = (_a.sent()).port;
                    console.info("Serving files on http://localhost:".concat(port));
                    _a.label = 4;
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.handleWatchMode = handleWatchMode;
function printBanner(config) {
    // Convert the config object into an array of key-value pairs
    var entries = Object.entries(config);
    // Calculate the maximum key length
    var maxKeyLength = Math.max.apply(Math, entries.map(function (_a) {
        var key = _a[0];
        return key.length;
    }));
    // Generate the lines of the banner
    var lines = entries.map(function (_a) {
        var key = _a[0], value = _a[1];
        var paddedKey = key.padEnd(maxKeyLength + 2, ' ');
        return "".concat(paddedKey, ": ").concat(String(value));
    });
    // Print the banner
    console.log("\n".concat(IBundler_1.BUNDLER_NAME, "\n").concat(lines.join('\n'), "\n"));
}
exports.printBanner = printBanner;
function resolveConfig(_a) {
    var outdir = _a.outdir, parameters = _a.parameters, argv = _a.argv;
    var mode = argv.includes('--serve') ? 'serve' : argv.includes('--watch') ? 'watch' : 'build';
    var config = {
        environment: parameters.environment,
        NODE_ENV: parameters.NODE_ENV,
        outdir: outdir,
        mode: mode,
        typeCheck: !argv.includes('--skipTypeCheck') && mode === 'build',
    };
    return config;
}
exports.resolveConfig = resolveConfig;
function transpileFiles(files, options) {
    var _a, files_1, files_1_1;
    var _b, e_2, _c, _d;
    return __awaiter(this, void 0, void 0, function () {
        var promises, _loop_1, e_2_1;
        var _this = this;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    promises = [];
                    _e.label = 1;
                case 1:
                    _e.trys.push([1, 6, 7, 12]);
                    _loop_1 = function () {
                        _d = files_1_1.value;
                        _a = false;
                        try {
                            var file = _d;
                            promises.push((function () { return __awaiter(_this, void 0, void 0, function () {
                                var source, output;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            if (!file.endsWith('.js')) {
                                                return [2 /*return*/];
                                            }
                                            debug("Transpiling the file ".concat(file, " to es5"));
                                            return [4 /*yield*/, fs.promises.readFile(file)];
                                        case 1:
                                            source = _a.sent();
                                            return [4 /*yield*/, (0, core_1.transform)(source.toString('utf-8'), options)];
                                        case 2:
                                            output = _a.sent();
                                            return [4 /*yield*/, fs.promises.writeFile(file, output.code)];
                                        case 3:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); })());
                        }
                        finally {
                            _a = true;
                        }
                    };
                    _a = true, files_1 = __asyncValues(files);
                    _e.label = 2;
                case 2: return [4 /*yield*/, files_1.next()];
                case 3:
                    if (!(files_1_1 = _e.sent(), _b = files_1_1.done, !_b)) return [3 /*break*/, 5];
                    _loop_1();
                    _e.label = 4;
                case 4: return [3 /*break*/, 2];
                case 5: return [3 /*break*/, 12];
                case 6:
                    e_2_1 = _e.sent();
                    e_2 = { error: e_2_1 };
                    return [3 /*break*/, 12];
                case 7:
                    _e.trys.push([7, , 10, 11]);
                    if (!(!_a && !_b && (_c = files_1.return))) return [3 /*break*/, 9];
                    return [4 /*yield*/, _c.call(files_1)];
                case 8:
                    _e.sent();
                    _e.label = 9;
                case 9: return [3 /*break*/, 11];
                case 10:
                    if (e_2) throw e_2.error;
                    return [7 /*endfinally*/];
                case 11: return [7 /*endfinally*/];
                case 12: return [4 /*yield*/, Promise.all(promises)];
                case 13:
                    _e.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.transpileFiles = transpileFiles;
// Transpiles all js files in `outdir` to ES5 with SWC
function transpileToES5(_a) {
    var outdir = _a.outdir, _b = _a.options, options = _b === void 0 ? {} : _b;
    return __awaiter(this, void 0, void 0, function () {
        var extendedOptions;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    extendedOptions = __assign({ isModule: false }, options);
                    return [4 /*yield*/, transpileFiles(walk(outdir), extendedOptions)];
                case 1:
                    _c.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.transpileToES5 = transpileToES5;
// Walks a directory and yields every file
function walk(root, p) {
    if (p === void 0) { p = '.'; }
    return __asyncGenerator(this, arguments, function walk_1() {
        var dir, _i, dir_1, e;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, __await(fs.promises.stat(root))];
                case 1:
                    if (!(_a.sent()).isFile()) return [3 /*break*/, 5];
                    return [4 /*yield*/, __await(root)];
                case 2: return [4 /*yield*/, _a.sent()];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, __await(void 0)];
                case 4: return [2 /*return*/, _a.sent()];
                case 5: return [4 /*yield*/, __await(fs.promises.readdir(path.join(root, p), { withFileTypes: true }))];
                case 6:
                    dir = _a.sent();
                    _i = 0, dir_1 = dir;
                    _a.label = 7;
                case 7:
                    if (!(_i < dir_1.length)) return [3 /*break*/, 14];
                    e = dir_1[_i];
                    if (!e.isDirectory()) return [3 /*break*/, 10];
                    return [5 /*yield**/, __values(__asyncDelegator(__asyncValues(walk(root, path.join(p, e.name)))))];
                case 8: return [4 /*yield*/, __await.apply(void 0, [_a.sent()])];
                case 9:
                    _a.sent();
                    _a.label = 10;
                case 10:
                    if (!e.isFile()) return [3 /*break*/, 13];
                    return [4 /*yield*/, __await(path.join(root, p, e.name))];
                case 11: return [4 /*yield*/, _a.sent()];
                case 12:
                    _a.sent();
                    _a.label = 13;
                case 13:
                    _i++;
                    return [3 /*break*/, 7];
                case 14: return [2 /*return*/];
            }
        });
    });
}
exports.walk = walk;
//# sourceMappingURL=bundlerUtils.js.map