import { Options as swcOptions } from '@swc/core';
import { ServeOptions } from 'esbuild';
export declare const BUNDLER_NAME = "signageOS Assets Bundler";
type Environment = 'development' | 'test' | 'production';
export interface IEnvOptions {
    environment: Environment;
    NODE_ENV: Environment;
}
export interface IBundlerConfig extends IEnvOptions {
    outdir: string;
    mode: 'build' | 'serve' | 'watch';
    typeCheck: boolean;
}
export interface IBundlerOptions {
    argv: ('--watch' | '--serve' | '--skipTypeCheck' | (string & {}))[];
    outdir: string;
    parameters: IEnvOptions;
    serveOptions?: ServeOptions;
}
export interface ITranspileOptions {
    outdir: string;
    options?: swcOptions;
}
export {};
