import * as Debug from 'debug';
/**
 * Add to a class to debug all its method. Based on https://www.typescriptlang.org/docs/handbook/decorators.html#class-decorators
 *
 * For more information see https://www.npmjs.com/package/debug
 *
 * @param namespace Namespace of the debug logs. Run program with env variable DEBUG=<namespace> to enable the logs.
 */
export declare function debugClass(namespace: string, debugFactory?: Debug.IDebug): <T extends new (...args: any[]) => {}>(Target: T) => {
    new (...constructorArgs: any[]): {};
} & T;
