"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTime = exports.InvalidBrightnessSettingsPolicy = exports.validKeys = void 0;
exports.default = validateBrightnessSettingsPolicy;
exports.validateOneBrightnessSettingsPolicy = validateOneBrightnessSettingsPolicy;
const validateBrightnessSettings_1 = require("../../Device/Settings/Validation/validateBrightnessSettings");
const isValidTime_1 = require("../../Device/Time/Validation/isValidTime");
const Validation_1 = require("../../Validation/Validation");
const validateKeys_1 = require("../../Validation/validateKeys");
exports.validKeys = {
    brightness: true,
    time: true,
};
function validateBrightnessSettingsPolicy(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    if (!Array.isArray(settings)) {
        validation.addError(new InvalidBrightnessSettingsPolicy(settings));
    }
    else {
        settings === null || settings === void 0 ? void 0 : settings.forEach((setting) => {
            const settingValidation = validateOneBrightnessSettingsPolicy(setting);
            validation.addError(...settingValidation.getErrors());
        });
    }
    return validation.getOutput();
}
function validateOneBrightnessSettingsPolicy(settings) {
    var _a;
    const { time, brightness } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notTimeValid = !(0, isValidTime_1.default)(time);
    const brightnessValidation = (0, validateBrightnessSettings_1.default)({ brightness });
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notTimeValid) {
        validation.addError(new InvalidTime(time));
    }
    validation.addError(...keysValidation.getErrors());
    validation.addError(...brightnessValidation.getErrors());
    return validation.getOutput();
}
class InvalidBrightnessSettingsPolicy extends Error {
    constructor(settings) {
        super(`Brightness Settings Policy is not array: ${settings}`);
    }
}
exports.InvalidBrightnessSettingsPolicy = InvalidBrightnessSettingsPolicy;
class InvalidTime extends Error {
    constructor(time) {
        super(`Brightness Settings Policy Time is not valid (HH:mm): ${time}`);
    }
}
exports.InvalidTime = InvalidTime;
