"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyItemSchema = exports.PolicyItemSchemas = exports.createPolicyItemBaseSchema = void 0;
exports.isPolicyItemOfType = isPolicyItemOfType;
const zod_1 = require("zod");
const DeviceSettings_1 = require("../Device/Settings/DeviceSettings");
const DeviceSettingsType_1 = require("../Device/Settings/DeviceSettingsType");
const ApplicationType_1 = require("../Application/ApplicationType");
const object_1 = require("../TypeScript/object");
/**
 * Type guard for checking if the policy item is of the specified type.
 */
function isPolicyItemOfType(policyItem, type) {
    return policyItem.type === type;
}
const createPolicyItemBaseSchema = (type, valueSchema) => zod_1.z.strictObject({
    type: zod_1.z.literal(type),
    applicationType: ApplicationType_1.ApplicationTypeSchema.optional(),
    value: valueSchema,
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: zod_1.z.date().default(() => new Date()),
});
exports.createPolicyItemBaseSchema = createPolicyItemBaseSchema;
exports.PolicyItemSchemas = {
    [DeviceSettingsType_1.DeviceSettingsType.VOLUME]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.VOLUME, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.VOLUME]),
    // Values for brightness is the only differs from general DeviceSettings
    [DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS, zod_1.z.array(DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS].extend({
        time: zod_1.z.string(),
    }))),
    [DeviceSettingsType_1.DeviceSettingsType.TIMERS]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.TIMERS, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.TIMERS]),
    [DeviceSettingsType_1.DeviceSettingsType.PROPRIETARY_TIMERS]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.PROPRIETARY_TIMERS, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.PROPRIETARY_TIMERS]),
    [DeviceSettingsType_1.DeviceSettingsType.RESOLUTION]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.RESOLUTION, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.RESOLUTION]),
    [DeviceSettingsType_1.DeviceSettingsType.ORIENTATION]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.ORIENTATION, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.ORIENTATION]),
    [DeviceSettingsType_1.DeviceSettingsType.REMOTE_CONTROL]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.REMOTE_CONTROL, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.REMOTE_CONTROL]),
    [DeviceSettingsType_1.DeviceSettingsType.APPLICATION_VERSION]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.APPLICATION_VERSION, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.APPLICATION_VERSION]),
    [DeviceSettingsType_1.DeviceSettingsType.FIRMWARE_VERSION]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.FIRMWARE_VERSION, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.FIRMWARE_VERSION]),
    [DeviceSettingsType_1.DeviceSettingsType.DEBUG]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.DEBUG, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.DEBUG]),
    [DeviceSettingsType_1.DeviceSettingsType.DATETIME]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.DATETIME, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.DATETIME]),
    [DeviceSettingsType_1.DeviceSettingsType.POWER_ACTIONS_SCHEDULE]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.POWER_ACTIONS_SCHEDULE, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.POWER_ACTIONS_SCHEDULE]),
    [DeviceSettingsType_1.DeviceSettingsType.TEMPERATURE]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.TEMPERATURE, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.TEMPERATURE]),
    [DeviceSettingsType_1.DeviceSettingsType.AUTO_RECOVERY]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.AUTO_RECOVERY, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.AUTO_RECOVERY]),
    [DeviceSettingsType_1.DeviceSettingsType.PEER_RECOVERY]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.PEER_RECOVERY, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.PEER_RECOVERY]),
    [DeviceSettingsType_1.DeviceSettingsType.PROXY]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.PROXY, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.PROXY]),
    [DeviceSettingsType_1.DeviceSettingsType.CONNECTION_METHOD]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.CONNECTION_METHOD, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.CONNECTION_METHOD]),
    [DeviceSettingsType_1.DeviceSettingsType.PACKAGES]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.PACKAGES, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.PACKAGES]),
    [DeviceSettingsType_1.DeviceSettingsType.TELEMETRY_INTERVALS]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.TELEMETRY_INTERVALS, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.TELEMETRY_INTERVALS]),
    [DeviceSettingsType_1.DeviceSettingsType.APPLET]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.APPLET, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.APPLET]),
    [DeviceSettingsType_1.DeviceSettingsType.EXTENDED_MANAGEMENT]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.EXTENDED_MANAGEMENT, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.EXTENDED_MANAGEMENT]),
    [DeviceSettingsType_1.DeviceSettingsType.NETWORK_INTERFACES]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.NETWORK_INTERFACES, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.NETWORK_INTERFACES]),
    [DeviceSettingsType_1.DeviceSettingsType.DISPLAY_POWER_ON]: (0, exports.createPolicyItemBaseSchema)(DeviceSettingsType_1.DeviceSettingsType.DISPLAY_POWER_ON, DeviceSettings_1.DeviceSettingsSchemas[DeviceSettingsType_1.DeviceSettingsType.DISPLAY_POWER_ON]),
};
exports.PolicyItemSchema = zod_1.z.discriminatedUnion('type', (0, object_1.getObjectValues)(exports.PolicyItemSchemas));
