"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidFrontCapabilities = void 0;
exports.default = validateManagementCapabilitiesTelemetry;
exports.isArrayOfFrontCapabilities = isArrayOfFrontCapabilities;
const Validation_1 = require("../../../Validation/Validation");
const FrontCapability_1 = require("../../../Device/Capabilities/FrontCapability");
function validateManagementCapabilitiesTelemetry(settings) {
    var _a;
    const { capable } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidFrontCapabilities = !isArrayOfFrontCapabilities(capable);
    const validation = (0, Validation_1.createValidation)(settings);
    if (notValidFrontCapabilities) {
        validation.addError(new InvalidFrontCapabilities(capable));
    }
    return validation.getOutput();
}
function isArrayOfFrontCapabilities(capable) {
    const possibleValues = Object.values(FrontCapability_1.FrontCapabilities);
    return Array.isArray(capable) && capable.filter((value) => !possibleValues.includes(value)).length === 0;
}
class InvalidFrontCapabilities extends Error {
    constructor(_capable) {
        super('front capabilities have to be array of valid front capabilities');
    }
}
exports.InvalidFrontCapabilities = InvalidFrontCapabilities;
