"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidBrightness = exports.validKeys = void 0;
exports.default = validateBrightnessSettings;
exports.isValidBrightnessValue = isValidBrightnessValue;
const isValidUnsignedInteger_1 = require("../../../Validation/isValidUnsignedInteger");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    brightness: true,
};
function validateBrightnessSettings(settings) {
    var _a;
    const { brightness } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidBrightness = !isValidBrightnessValue(brightness);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidBrightness) {
        validation.addError(new InvalidBrightness(brightness));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function isValidBrightnessValue(brightness) {
    const isBrightnessUnsignedInteger = (0, isValidUnsignedInteger_1.default)(brightness);
    const isBrightnessInLimit = typeof brightness === 'number' && brightness <= 100;
    if (isBrightnessUnsignedInteger && isBrightnessInLimit) {
        return true;
    }
    else {
        return false;
    }
}
class InvalidBrightness extends Error {
    constructor(brightness) {
        super(`Brightness is not in range 0 to 100: ${JSON.stringify(brightness)}`);
    }
}
exports.InvalidBrightness = InvalidBrightness;
