"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidAutoRecoverySettingsAutoEnableTimeoutMs = exports.InvalidAutoRecoverySettingsHealthcheckIntervalMs = exports.InvalidAutoRecoverySettingsEnabled = exports.validKeys = void 0;
exports.default = validateAutoRecoverySettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    enabled: true,
    healthcheckIntervalMs: true,
    autoEnableTimeoutMs: true,
};
function validateAutoRecoverySettings(settings) {
    var _a;
    const { enabled, healthcheckIntervalMs, autoEnableTimeoutMs } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const enabledInvalid = typeof enabled !== 'boolean';
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (enabledInvalid) {
        validation.addError(new InvalidAutoRecoverySettingsEnabled(enabled));
    }
    else {
        if (enabled) {
            const healthcheckIntervalMsValid = typeof healthcheckIntervalMs === 'number' && Number.isSafeInteger(healthcheckIntervalMs) && healthcheckIntervalMs > 0;
            if (!healthcheckIntervalMsValid) {
                validation.addError(new InvalidAutoRecoverySettingsHealthcheckIntervalMs(healthcheckIntervalMs));
            }
        }
        else {
            const autoEnableTimeoutMsValid = autoEnableTimeoutMs === undefined ||
                (typeof autoEnableTimeoutMs === 'number' && Number.isSafeInteger(autoEnableTimeoutMs) && autoEnableTimeoutMs > 0);
            if (!autoEnableTimeoutMsValid) {
                validation.addError(new InvalidAutoRecoverySettingsAutoEnableTimeoutMs(autoEnableTimeoutMs));
            }
        }
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidAutoRecoverySettingsEnabled extends Error {
    constructor(enabled) {
        super(`Auto recovery settings field 'enabled' is not boolean: ${enabled}`);
    }
}
exports.InvalidAutoRecoverySettingsEnabled = InvalidAutoRecoverySettingsEnabled;
class InvalidAutoRecoverySettingsHealthcheckIntervalMs extends Error {
    constructor(healthcheckIntervalMs) {
        super(`Auto recovery settings field 'healthcheckIntervalMs' is not positive number: ${healthcheckIntervalMs}`);
    }
}
exports.InvalidAutoRecoverySettingsHealthcheckIntervalMs = InvalidAutoRecoverySettingsHealthcheckIntervalMs;
class InvalidAutoRecoverySettingsAutoEnableTimeoutMs extends Error {
    constructor(autoEnableTimeoutMs) {
        super(`Auto recovery settings field 'autoEnableTimeoutMs' is not positive number: ${autoEnableTimeoutMs}`);
    }
}
exports.InvalidAutoRecoverySettingsAutoEnableTimeoutMs = InvalidAutoRecoverySettingsAutoEnableTimeoutMs;
