"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulkProvisioningRecipeRequiredProperties = exports.BulkProvisioningRecipeProperty = exports.BulkProvisioningDeviceProperties = exports.BulkProvisioningBrands = exports.BulkProvisioningUniquenessHashMap = exports.BulkProvisioningRequiredProperties = exports.BulkProvisioningUniqueness = exports.BulkProvisioningDeviceProperty = exports.BulkProvisioningBrand = void 0;
exports.hashByBrand = hashByBrand;
exports.isBrand = isBrand;
const object_1 = require("@signageos/lib/dist/Utils/object");
var BulkProvisioningBrand;
(function (BulkProvisioningBrand) {
    BulkProvisioningBrand["Sony"] = "Sony";
    BulkProvisioningBrand["LG"] = "LG";
    BulkProvisioningBrand["Samsung"] = "Samsung";
    BulkProvisioningBrand["BrightSign"] = "BrightSign";
})(BulkProvisioningBrand || (exports.BulkProvisioningBrand = BulkProvisioningBrand = {}));
var BulkProvisioningDeviceProperty;
(function (BulkProvisioningDeviceProperty) {
    BulkProvisioningDeviceProperty["SerialNumber"] = "serialNumber";
    BulkProvisioningDeviceProperty["Model"] = "model";
    BulkProvisioningDeviceProperty["MacAddress"] = "macAddress";
})(BulkProvisioningDeviceProperty || (exports.BulkProvisioningDeviceProperty = BulkProvisioningDeviceProperty = {}));
exports.BulkProvisioningUniqueness = {
    [BulkProvisioningBrand.Sony]: (device) => device.macAddress,
    [BulkProvisioningBrand.LG]: (device) => device.serialNumber,
    [BulkProvisioningBrand.Samsung]: (device) => device.serialNumber,
    [BulkProvisioningBrand.BrightSign]: (device) => device.serialNumber,
};
exports.BulkProvisioningRequiredProperties = {
    [BulkProvisioningBrand.Sony]: [BulkProvisioningDeviceProperty.MacAddress],
    [BulkProvisioningBrand.LG]: [BulkProvisioningDeviceProperty.SerialNumber],
    [BulkProvisioningBrand.Samsung]: [BulkProvisioningDeviceProperty.SerialNumber],
    [BulkProvisioningBrand.BrightSign]: [BulkProvisioningDeviceProperty.SerialNumber],
};
exports.BulkProvisioningUniquenessHashMap = {
    [BulkProvisioningBrand.Sony]: (device) => `${device === null || device === void 0 ? void 0 : device.macAddress}`,
    [BulkProvisioningBrand.LG]: (device) => `${device === null || device === void 0 ? void 0 : device.serialNumber}`,
    [BulkProvisioningBrand.Samsung]: (device) => `${device === null || device === void 0 ? void 0 : device.serialNumber}`,
    [BulkProvisioningBrand.BrightSign]: (device) => `${device === null || device === void 0 ? void 0 : device.serialNumber}`,
};
function hashByBrand({ brand, deviceProperties, }) {
    const hash = `${brand}`;
    const uniquenessFn = exports.BulkProvisioningUniquenessHashMap[brand];
    const uniquenessValue = uniquenessFn(deviceProperties);
    return `${hash}-${uniquenessValue}`;
}
function isBrand(x) {
    const values = Object.values(BulkProvisioningBrand);
    return values.find((value) => value === x) !== undefined;
}
exports.BulkProvisioningBrands = (0, object_1.getObjectKeys)(exports.BulkProvisioningUniqueness);
exports.BulkProvisioningDeviceProperties = (0, object_1.getObjectKeys)(BulkProvisioningDeviceProperty);
var BulkProvisioningRecipeProperty;
(function (BulkProvisioningRecipeProperty) {
    BulkProvisioningRecipeProperty["ConfirmedOwnership"] = "confirmedOwnership";
})(BulkProvisioningRecipeProperty || (exports.BulkProvisioningRecipeProperty = BulkProvisioningRecipeProperty = {}));
exports.BulkProvisioningRecipeRequiredProperties = {
    [BulkProvisioningBrand.Sony]: [BulkProvisioningRecipeProperty.ConfirmedOwnership],
};
