"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstalledPackagesSchema = void 0;
const zod_1 = require("zod");
const specs_1 = require("../../Package/Android/specs");
/**
 * List of all currently installed packages on the device.
 */
exports.InstalledPackagesSchema = zod_1.z.object({
    /** Currently supported only for android */
    applicationType: zod_1.z.literal('android'),
    packages: zod_1.z.array(zod_1.z.object({
        buildHash: zod_1.z.string(),
        specs: specs_1.AndroidInstalledSpecsSchema,
    })),
});
