import { z } from 'zod';
export declare const TizenDevicePackageInstallationFromUriSchema: z.ZodObject<{
    packageUri: z.ZodString;
    applicationType: z.ZodLiteral<"tizen">;
    specs: z.ZodOptional<z.ZodNever>;
}, "strict", z.ZodTypeAny, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}>;
export type TizenDevicePackageInstallationFromUri = z.infer<typeof TizenDevicePackageInstallationFromUriSchema>;
export declare const AndroidDevicePackageInstallationFromUriSchema: z.ZodObject<{
    packageUri: z.ZodString;
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>;
export type AndroidDevicePackageInstallationFromUri = z.infer<typeof AndroidDevicePackageInstallationFromUriSchema>;
export declare const DevicePackageInstallationFromUriSchema: z.ZodDiscriminatedUnion<"applicationType", [z.ZodObject<{
    packageUri: z.ZodString;
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>, z.ZodObject<{
    packageUri: z.ZodString;
    applicationType: z.ZodLiteral<"tizen">;
    specs: z.ZodOptional<z.ZodNever>;
}, "strict", z.ZodTypeAny, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}>]>;
export type DevicePackageInstallationFromUri = z.infer<typeof DevicePackageInstallationFromUriSchema>;
