"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinScreenthotIntervalsByPlan = exports.MinScreenshotIntervalsByPlan = exports.MinTelemetryIntervalsByPlan = exports.DEFAULT_MIN_TELEMETRY_INTERVAL = exports.MinTelemetryIntervals = exports.TelemetryCheckIntervalsSchema = exports.PositiveNumberOptionalSchema = exports.TelemetryConfigurationCheckInterval = void 0;
const subscription_1 = require("../../Subscription/subscription");
const zod_1 = require("zod");
/**
 * `DeviceTelemetryType` loosely corresponts with with `TelemetryConfigurationCheckInterval`
 */
var TelemetryConfigurationCheckInterval;
(function (TelemetryConfigurationCheckInterval) {
    TelemetryConfigurationCheckInterval["SCREENSHOTS"] = "screenshots";
    TelemetryConfigurationCheckInterval["TEMPERATURE"] = "temperature";
    TelemetryConfigurationCheckInterval["APPLICATION_VERSION"] = "applicationVersion";
    TelemetryConfigurationCheckInterval["FRONT_DISPLAY_VERSION"] = "frontDisplayVersion";
    TelemetryConfigurationCheckInterval["BRIGHTNESS"] = "brightness";
    TelemetryConfigurationCheckInterval["DATETIME"] = "datetime";
    TelemetryConfigurationCheckInterval["DEBUG"] = "debug";
    TelemetryConfigurationCheckInterval["FIRMWARE_VERSION"] = "firmwareVersion";
    TelemetryConfigurationCheckInterval["ORIENTATION"] = "orientation";
    TelemetryConfigurationCheckInterval["POWER_ACTIONS_SCHEDULE"] = "powerActionsSchedule";
    TelemetryConfigurationCheckInterval["PROPRIETARY_TIMERS"] = "proprietaryTimers";
    TelemetryConfigurationCheckInterval["REMOTE_CONTROL"] = "remoteControl";
    TelemetryConfigurationCheckInterval["RESOLUTION"] = "resolution";
    TelemetryConfigurationCheckInterval["TIMERS"] = "timers";
    TelemetryConfigurationCheckInterval["VOLUME"] = "volume";
    TelemetryConfigurationCheckInterval["STORAGE"] = "storage";
    TelemetryConfigurationCheckInterval["BATTERY"] = "battery";
    TelemetryConfigurationCheckInterval["POLICY"] = "policy";
    TelemetryConfigurationCheckInterval["PEER_RECOVERY"] = "peerRecovery";
    TelemetryConfigurationCheckInterval["AUTO_RECOVERY"] = "autoRecovery";
    TelemetryConfigurationCheckInterval["EXTENDED_MANAGEMENT"] = "extendedManagement";
    TelemetryConfigurationCheckInterval["DEFAULT"] = "default";
})(TelemetryConfigurationCheckInterval || (exports.TelemetryConfigurationCheckInterval = TelemetryConfigurationCheckInterval = {}));
exports.PositiveNumberOptionalSchema = zod_1.z.number().positive().optional();
exports.TelemetryCheckIntervalsSchema = zod_1.z
    .object({
    [TelemetryConfigurationCheckInterval.SCREENSHOTS]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.TEMPERATURE]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.APPLICATION_VERSION]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.FRONT_DISPLAY_VERSION]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.BRIGHTNESS]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.DATETIME]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.DEBUG]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.FIRMWARE_VERSION]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.ORIENTATION]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.POWER_ACTIONS_SCHEDULE]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.PROPRIETARY_TIMERS]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.REMOTE_CONTROL]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.RESOLUTION]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.TIMERS]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.VOLUME]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.STORAGE]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.BATTERY]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.POLICY]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.PEER_RECOVERY]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.AUTO_RECOVERY]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.EXTENDED_MANAGEMENT]: exports.PositiveNumberOptionalSchema,
    [TelemetryConfigurationCheckInterval.DEFAULT]: exports.PositiveNumberOptionalSchema,
})
    .strict();
const BLAZING_FAST_TELEMETRY_INTERVAL = 5 * 60 * 1e3; // 5 minutes
const SUPER_FAST_TELEMETRY_INTERVAL = 15 * 60 * 1e3; // 15 minutes
const FAST_TELEMETRY_INTERVAL = 60 * 60 * 1e3; // 60 minutes
const SLOW_TELEMETRY_INTERVAL = 3 * 60 * 60 * 1e3; // 3 hours
const SUPER_SLOW_TELEMETRY_INTERVAL = 6 * 60 * 60 * 1e3; // 6 hours
const KEEP_ALIVE_TELEMETRY_INTERVAL = 24 * 60 * 60 * 1e3; // 1 day (practically disabled)
exports.MinTelemetryIntervals = {
    [TelemetryConfigurationCheckInterval.SCREENSHOTS]: SUPER_FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.TEMPERATURE]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.APPLICATION_VERSION]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.FRONT_DISPLAY_VERSION]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.BRIGHTNESS]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.DATETIME]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.DEBUG]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.FIRMWARE_VERSION]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.ORIENTATION]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.POWER_ACTIONS_SCHEDULE]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.PROPRIETARY_TIMERS]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.REMOTE_CONTROL]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.RESOLUTION]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.TIMERS]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.VOLUME]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.STORAGE]: SLOW_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.BATTERY]: SLOW_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.POLICY]: BLAZING_FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.PEER_RECOVERY]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.AUTO_RECOVERY]: FAST_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.EXTENDED_MANAGEMENT]: SLOW_TELEMETRY_INTERVAL,
    [TelemetryConfigurationCheckInterval.DEFAULT]: FAST_TELEMETRY_INTERVAL,
};
exports.DEFAULT_MIN_TELEMETRY_INTERVAL = FAST_TELEMETRY_INTERVAL;
exports.MinTelemetryIntervalsByPlan = {
    [subscription_1.SubscriptionType.Open]: KEEP_ALIVE_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Basic]: SUPER_SLOW_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Medium]: SLOW_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.All]: FAST_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Platform]: FAST_TELEMETRY_INTERVAL,
};
exports.MinScreenshotIntervalsByPlan = {
    [subscription_1.SubscriptionType.Open]: KEEP_ALIVE_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Basic]: KEEP_ALIVE_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Medium]: KEEP_ALIVE_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.All]: SUPER_FAST_TELEMETRY_INTERVAL,
    [subscription_1.SubscriptionType.Platform]: SUPER_FAST_TELEMETRY_INTERVAL,
};
/** @deprecated Use MinScreenshotIntervalsByPlan */
exports.MinScreenthotIntervalsByPlan = exports.MinScreenshotIntervalsByPlan;
