export type AutoRecoveryEnabled = {
    enabled: true;
    /**
     * It defines in milliseconds period whose elapsing leads to mark browser process as unresponding.
     */
    healthcheckIntervalMs: number;
};
export type AutoRecoveryDisabled = {
    enabled: false;
    autoEnableTimeoutMs?: number;
};
export type PeerRecoveryEnabled = {
    enabled: true;
    /**
     * This URL address has to be set in URL launcher on device that is recovered.
     */
    urlLauncherAddress: string;
};
export type PeerRecoveryDisabled = {
    enabled: false;
    autoEnableTimeoutMs: number;
};
